/*!
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.2
 *
 * @date        2022-06-23
 *
 * @attention
 *
 *  Copyright (C) 2021-2022 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be usefull and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes */
#include "main.h"
#include "stdio.h"
#include "Board.h"
#include "apm32f4xx_fmc.h"

/** @addtogroup Examples
  @{
  */

/** @addtogroup FMC_Write
  @{
  */

/** @defgroup FMC_Write_Macros Macros
  @{
*/

/* printf using USART1  */
#define DEBUG_USART  USART1

/**@} end of group FMC_Write_Macros*/

/** @defgroup FMC_Write_Functions Functions
  @{
  */

/*!
 * @brief     Main program
 *
 * @param     None
 *
 * @retval    None
 */
int main(void)
{
    uint32_t       address;
    uint32_t       data;
    FMC_SECTOR_T   sector;
    FMC_VOLTAGE_T  voltagerange;
    USART_Config_T usartConfigStruct;

    /* USART configuration */
    USART_ConfigStructInit(&usartConfigStruct);
    usartConfigStruct.baudRate = 115200;
    usartConfigStruct.mode = USART_MODE_TX_RX;
    usartConfigStruct.parity = USART_PARITY_NONE;
    usartConfigStruct.stopBits = USART_STOP_BIT_1;
    usartConfigStruct.wordLength = USART_WORD_LEN_8B;
    usartConfigStruct.hardwareFlow = USART_HARDWARE_FLOW_NONE;

    /* COM1 init*/
    APM_MINI_COMInit(COM1, &usartConfigStruct);

    /* Unlock Flash for Erase or Write*/
    FMC_Unlock();

    /* Set address*/
    sector       = FMC_SECTOR_6;
    voltagerange = FMC_VOLTAGE_3;
    address      = 0x08040000;
    data         = 0x12345678;
    /* Reset sector data*/
    FMC_EraseSector(sector, voltagerange);
    /* Read Address data*/
    printf("\r\nAfter EraseSector,address = 0x08040000;data = 0x%08x\r\n", *(volatile uint32_t*)address);

    /* Write data in address*/
    FMC_ProgramWord(address, data);

    /* Read data again*/
    printf("After ProgramWord,address = 0x08040000,data = 0x%08x\r\n", *(volatile uint32_t*)address);

    /* Lock Flash*/
    FMC_Lock();

    while (1)
    {
    }
}

/*!
 * @brief     Redirect C Library function printf to serial port.
 *            After Redirection, you can use printf function.
 *
 * @param     ch:  The characters that need to be send.
 *
 * @param     *f:  pointer to a FILE that can recording all information
 *            needed to control a stream
 *
 * @retval    The characters that need to be send.
 */
int fputc(int ch, FILE* f)
{
    /* send a byte of data to the serial port */
    USART_TxData(DEBUG_USART, (uint8_t)ch);

    /* wait for the data to be send  */
    while (USART_ReadStatusFlag(DEBUG_USART, USART_FLAG_TXBE) == RESET);

    return (ch);
}

/**@} end of group FMC_Write_Functions */
/**@} end of group FMC_Write */
/**@} end of group Examples */
